﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace Winfoot_7_SDK
{
    public enum OS
    {
        WindowsXP = 2510,
        WindoesXP_SP1 = 2511,
        WindowsXP_SP2 = 2512,
        WindowsXP_SP3 = 2513,
        WindowsVista=2600,
        WindowsVista_SP1 = 2601,
        WindowsVista_SP2 = 2602,
        WindowsVista_SP3 = 2603,
        WindowsSeven = 2610,
        WindowsSeven_SP1=2611,
        WindowsSeven_SP2=2612
    }
    public interface ICorrespondenceOS
    {
        List<OS> CorrespondenceOSList
        {
            get;
            set;
        }
    }

    public class WFUtillity
    {

        public bool CheckCorrespondence(ICorrespondenceOS correspondenceOS)
        {
            int version = GetOSVersion();
            for (int count = 0; count < correspondenceOS.CorrespondenceOSList.Count; count++)
            {
                if ((int)correspondenceOS.CorrespondenceOSList[count] == version)
                {
                    return true;
                }
            }

            return false;
        }

        public ICorrespondenceOS GetCorrespondenceInstance(List<ICorrespondenceOS> correspondenceOSS)
        {
            for (int count = 0; count < correspondenceOSS.Count; count++)
            {
                if(CheckCorrespondence(correspondenceOSS[count]))
                {
                    return correspondenceOSS[count];
                }
            }

            //まずあり得ない
            return null;
        }

        private int GetOSVersion()
        {
            OperatingSystem operatingSystem = Environment.OSVersion;
            Match match = Regex.Match(Environment.OSVersion.ServicePack, "[0-9]");
            int version = Convert.ToInt32(match.Value);
            switch (operatingSystem.Platform)
            {
                case PlatformID.Win32NT:
                    {
                        switch (operatingSystem.Version.Major)
                        {
                            case 5:
                                if (operatingSystem.Version.Minor == 1)
                                {
                                    version += 2510;
                                }
                                break;
                            case 6:
                                if (operatingSystem.Version.Minor == 0)
                                {
                                    version += 2600;
                                }
                                break;
                        }
                    }
                    break;
            }
            return version;
        }
    }
}
